from hashlib import sha1

from Crypto.Cipher import AES


def is_valid_key(key: bytes) -> bool:
    return (
        sha1(key).hexdigest().casefold() == "dea375ef1e6ef2223a1221c2c575c47bf17efa5e"
    )


def decrypt_block(block: bytes, aes_key: bytes) -> bytes:
    """Decrypt a single 16-byte block using AES-128 ECB, 16 times."""
    cipher = AES.new(aes_key, AES.MODE_ECB)
    for _ in range(16):
        block = cipher.decrypt(block)
    return block


def decrypt_aes(ciphertext: bytes, aes_key: str | bytes) -> bytes:
    if isinstance(aes_key, str):
        key = bytes.fromhex(aes_key)
    else:
        key = aes_key
    assert len(key) == 32, "Invalid Key Size."
    if not is_valid_key(key):
        raise Exception("Invalid Key")

    plaintext = bytearray()

    for i in range(0, len(ciphertext), 16):
        block = ciphertext[i : i + 16]
        if len(block) < 16:
            plaintext.extend(block)  # leave last short block as-is
        else:
            decrypted = decrypt_block(block, key)
            plaintext.extend(decrypted)

    return bytes(plaintext)
